package ru.yandex.http.util.request.function;

import java.text.ParseException;
import java.util.concurrent.ExecutionException;

public class ModFunction<V extends RequestFunctionContext>
    implements RequestFunction<V>
{
    private final RequestFunction<V> dividend;
    private final RequestFunction<V> divisor;

    public ModFunction(final RequestFunction<V>[] args)
        throws ParseException
    {
        if (args.length != 2) {
            throw new ParseException(
                "Function \"mod\" accepts 2 arguments",
                0);
        }
        dividend = args[0];
        divisor = args[1];
    }

    @Override
    public RequestFunctionValue value(final V context)
        throws ExecutionException
    {
        long dividend = this.dividend.value(context).longValue();
        long divisor = this.divisor.value(context).longValue();
        try {
            return new LongValue(dividend % divisor);
        } catch (ArithmeticException e) {
            throw new ExecutionException(
                "Can't get modulo for " + dividend + " and " + divisor,
                e);
        }
    }

    @Override
    public String toString() {
        return "mod(" + dividend + ',' + divisor + ')';
    }
}
