package ru.yandex.http.util.request.function;

import java.text.ParseException;

public enum RequestFunctionType {
    CONST {
        @Override
        public <V extends RequestFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            throw new ParseException(
                "\"const\" function must not be called explicitly",
                0);
        }
    },
    CONCAT {
        @Override
        public <V extends RequestFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new ConcatFunction<>(args);
        }
    },
    GET {
        @Override
        public <V extends RequestFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new GetFunction<>(args);
        }
    },
    GET_OR_NULL {
        @Override
        public <V extends RequestFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new GetOrNullFunction<>(args);
        }
    },
    GET_PATH {
        @Override
        public <V extends RequestFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new GetPathFunction<>();
        }
    },
    UNIQUE_ID {
        @Override
        public <V extends RequestFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
        {
            return new UniqueIdFunction<>();
        }
    },
    MOD {
        @Override
        public <V extends RequestFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new ModFunction<>(args);
        }
    },
    HASH {
        @Override
        public <V extends RequestFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException
        {
            return new HashFunction<>(args);
        }
    };

    public abstract
        <V extends RequestFunctionContext> RequestFunction<V> create(
            final RequestFunction<V>[] args)
            throws ParseException;
}
