package ru.yandex.http.util.request.function;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutionException;

import org.apache.http.HttpHost;

import ru.yandex.function.VoidProcessor;

public interface RequestFunctionValue {
    int OBJECT_WEIGHT = 24;

    int weight();

    String stringValue();

    boolean equalsString(String value);

    default <E extends Exception> void appendTo(
        final VoidProcessor<? super byte[], E> processor)
        throws E
    {
        processor.process(stringValue().getBytes(StandardCharsets.UTF_8));
    }

    default long longValue() throws ExecutionException {
        throw new ExecutionException(new NoSuchMethodException());
    }

    default double doubleValue() throws ExecutionException {
        throw new ExecutionException(new NoSuchMethodException());
    }

    default boolean booleanValue() throws ExecutionException {
        throw new ExecutionException(new NoSuchMethodException());
    }

    default List<HttpHost> hostListValue() throws ExecutionException {
        throw new ExecutionException(new NoSuchMethodException());
    }
}
