package ru.yandex.http.server.sync;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentProducer;

import ru.yandex.http.server.sync.util.LazyInputStream;

public class CloseableEntityTemplate extends AbstractHttpEntity {
    private final ContentProducer producer;
    private final Closeable closeable;

    public CloseableEntityTemplate(
        final ContentProducer producer,
        final Closeable closeable)
    {
        this.producer = producer;
        this.closeable = closeable;
    }

    @Override
    public long getContentLength() {
        return -1;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new LazyInputStream(producer) {
            @Override
            public void close() throws IOException {
                if (open()) {
                    closeable.close();
                }
                super.close();
            }
        };
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    @SuppressWarnings("try")
    public void writeTo(final OutputStream out) throws IOException {
        try (Closeable closeable = this.closeable) {
            producer.writeTo(out);
        }
    }

    @Override
    public boolean isStreaming() {
        return true;
    }
}

