package ru.yandex.http.server.sync;

import org.apache.http.Header;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerMapper;

import ru.yandex.http.util.request.RequestHandlerMapper;

public class CompositeHttpRequestHandlerMapper
    extends RequestHandlerMapper<HttpRequestHandler>
    implements HttpRequestHandlerMapper
{
    @Override
    public HttpRequestHandler dummyHandler(
        final int statusCode,
        final String body)
    {
        return new DummyHttpRequestHandler(statusCode, body);
    }

    @Override
    public HttpRequestHandler dummyHandler(
        final int statusCode,
        final String body,
        final Header header)
    {
        return new DummyHttpRequestHandler(statusCode, body, header);
    }

    @Override
    public HttpRequestHandler dummyHandler(
        final int statusCode,
        final String body,
        final Header... headers)
    {
        return new DummyHttpRequestHandler(statusCode, body, headers);
    }
}

