package ru.yandex.http.server.sync;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentProducer;

import ru.yandex.charset.StreamEncoder;
import ru.yandex.http.util.CharsetUtils;

public class ContentProducerWriter implements ContentProducer {
    private final ContentWriter contentWriter;
    private final CharsetEncoder encoder;

    public ContentProducerWriter(
        final ContentWriter contentWriter,
        final HttpRequest request)
        throws HttpException
    {
        this(contentWriter, CharsetUtils.acceptedCharset(request));
    }

    public ContentProducerWriter(
        final ContentWriter contentWriter,
        final Charset charset)
    {
        this(contentWriter, charset.newEncoder()
            .onMalformedInput(CodingErrorAction.REPLACE)
            .onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public ContentProducerWriter(
        final ContentWriter contentWriter,
        final CharsetEncoder encoder)
    {
        this.contentWriter = contentWriter;
        this.encoder = encoder;
    }

    @Override
    public void writeTo(final OutputStream out) throws IOException {
        Writer writer = new StreamEncoder(out, encoder);
        contentWriter.writeTo(writer);
        writer.close();
    }
}

