package ru.yandex.http.server.sync;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.HttpServer;

public class CustomAlertsConfigHandler implements HttpRequestHandler {
    private final HttpServer<?, ?> server;

    public CustomAlertsConfigHandler(final HttpServer<?, ?> server) {
        this.server = server;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException
    {
        response.setEntity(
            new StringEntity(
                server.customAlerts(request).toString(),
                ContentType.TEXT_PLAIN));
    }

    @Override
    public String toString() {
        return "Prints custom server alerts config";
    }
}

