package ru.yandex.http.server.sync;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class DisablePingHandler implements HttpRequestHandler {
    private final Runnable pingDisabler;

    public DisablePingHandler(final Runnable pingDisabler) {
        this.pingDisabler = pingDisabler;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
    {
        pingDisabler.run();
        response.setStatusCode(HttpStatus.SC_OK);
    }

    @Override
    public String toString() {
        return "Disables /ping requests handling";
    }
}
