package ru.yandex.http.server.sync;

import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.CharsetUtils;

public class DummyHttpRequestHandler implements HttpRequestHandler {
    private static final Header[] EMPTY_HEADERS = new Header[0];

    private final int statusCode;
    private final String body;
    private final Header[] headers;

    public DummyHttpRequestHandler(
        final int statusCode,
        final String body)
    {
        this.statusCode = statusCode;
        this.body = body;
        headers = EMPTY_HEADERS;
    }

    public DummyHttpRequestHandler(
        final int statusCode,
        final String body,
        final Header header)
    {
        this.statusCode = statusCode;
        this.body = body;
        headers = new Header[] {header};
    }

    public DummyHttpRequestHandler(
        final int statusCode,
        final String body,
        final Header... headers)
    {
        this.statusCode = statusCode;
        this.body = body;
        if (headers.length == 0) {
            this.headers = EMPTY_HEADERS;
        } else {
            this.headers = headers.clone();
        }
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException
    {
        response.setStatusCode(statusCode);
        if (body != null) {
            response.setEntity(
                new StringEntity(
                    body,
                    CharsetUtils.acceptedCharset(request)));
        }
        for (Header header: headers) {
            response.addHeader(header);
        }
    }
}

