package ru.yandex.http.server.sync;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.IBMDumper;

public class DumpHandler implements HttpRequestHandler {
    private final IBMDumper dumper;

    public DumpHandler(final IBMDumper dumper) {
        this.dumper = dumper;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException
    {
        dumper.process(request, context);
    }

    @Override
    public String toString() {
        return "Uses IBM JVM API to produce various process dumps";
    }
}

