package ru.yandex.http.server.sync;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.AbstractConfigUpdateHandler;
import ru.yandex.logger.PrefixedLogger;

public class DynamycConfigUpdateHandler
    extends AbstractConfigUpdateHandler
    implements HttpRequestHandler
{
    public DynamycConfigUpdateHandler(final BaseHttpServer<?> server) {
        super(server);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        PrefixedLogger logger =
            HttpCoreContext.adapt(context).getAttribute(
                BaseHttpServer.LOGGER,
                PrefixedLogger.class);

        response.setEntity(handle(request, logger));
    }
}
