package ru.yandex.http.server.sync;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

public class EnablePingHandler implements HttpRequestHandler {
    private final Runnable pingEnabler;

    public EnablePingHandler(final Runnable pingEnabler) {
        this.pingEnabler = pingEnabler;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
    {
        pingEnabler.run();
        response.setStatusCode(HttpStatus.SC_OK);
    }

    @Override
    public String toString() {
        return "Enables /ping requests handling";
    }
}
