package ru.yandex.http.server.sync;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.HttpServer;
import ru.yandex.json.writer.JsonTypeExtractor;

public class GenerateGolovanPanelHandler implements HttpRequestHandler {
    private final HttpServer<?, ?> server;

    public GenerateGolovanPanelHandler(final HttpServer<?, ?> server) {
        this.server = server;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException
    {
        response.setEntity(
            new JsonEntity(
                server.golovanPanel(request),
                request,
                JsonTypeExtractor.HUMAN_READABLE));
    }

    @Override
    public String toString() {
        return "Prints server metrics golovan panel";
    }
}

