package ru.yandex.http.server.sync;

import java.io.IOException;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.BadRequestException;

public class HttpEntityEnclosingRequestHandlerAdapter
    implements HttpRequestHandler
{
    private final HttpEntityEnclosingRequestHandler handler;

    public HttpEntityEnclosingRequestHandlerAdapter(
        final HttpEntityEnclosingRequestHandler handler)
    {
        this.handler = handler;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        if (request instanceof HttpEntityEnclosingRequest) {
            handler.handle(
                (HttpEntityEnclosingRequest) request,
                response,
                context);
        } else {
            throw new BadRequestException("POST requests must have body");
        }
    }

    @Override
    public String toString() {
        return handler.toString();
    }
}

