package ru.yandex.http.server.sync;

import java.io.IOException;
import java.nio.channels.SocketChannel;

import org.apache.http.config.ConnectionConfig;

import ru.yandex.function.GenericAutoCloseable;

public abstract class HttpServerConnectionFactory {
    protected final BaseHttpServer<?> server;
    protected final ConnectionConfig connectionConfig;

    protected HttpServerConnectionFactory(
        final BaseHttpServer<?> server,
        final ConnectionConfig connectionConfig)
    {
        this.server = server;
        this.connectionConfig = connectionConfig;
    }

    public abstract LoggingHttpServerConnection create(
        final SocketChannel channel,
        final GenericAutoCloseable<RuntimeException> releaser)
        throws IOException;
}

