package ru.yandex.http.server.sync;

import java.util.logging.Logger;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;

import ru.yandex.http.util.server.LoggingServerConnection;
import ru.yandex.parser.uri.CgiParams;

public class HttpSession {
    private final HttpRequest request;
    private final HttpResponse response;
    private final HttpCoreContext context;
    private final LoggingServerConnection conn;
    private final CgiParams params;
    private final Logger logger;

    public HttpSession(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
    {
        this.request = request;
        this.response = response;
        this.context = HttpCoreContext.adapt(context);
        conn = this.context.getConnection(LoggingServerConnection.class);
        params = new CgiParams(request);
        logger = (Logger) context.getAttribute(BaseHttpServer.LOGGER);
    }

    public HttpRequest request() {
        return request;
    }

    public HttpResponse response() {
        return response;
    }

    public HttpCoreContext context() {
        return context;
    }

    public LoggingServerConnection conn() {
        return conn;
    }

    public CgiParams params() {
        return params;
    }

    public Logger logger() {
        return logger;
    }
}

