package ru.yandex.http.server.sync;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentProducer;

import ru.yandex.charset.StreamEncoder;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.uri.ScanningCgiParams;

public class JsonContentProducerWriter implements ContentProducer {
    private final JsonValue jsonContentWriter;
    private final JsonType jsonType;
    private final CharsetEncoder encoder;

    public JsonContentProducerWriter(
        final JsonValue jsonContentWriter,
        final HttpRequest request)
        throws HttpException
    {
        this(jsonContentWriter, request, JsonTypeExtractor.NORMAL);
    }

    public JsonContentProducerWriter(
        final JsonValue jsonContentWriter,
        final HttpRequest request,
        final JsonTypeExtractor jsonTypeExtractor)
        throws HttpException
    {
        this(
            jsonContentWriter,
            jsonTypeExtractor.extract(new ScanningCgiParams(request)),
            CharsetUtils.acceptedCharset(request));
    }

    public JsonContentProducerWriter(
        final JsonValue jsonContentWriter,
        final JsonType jsonType,
        final Charset charset)
        throws HttpException
    {
        this.jsonContentWriter = jsonContentWriter;
        this.jsonType = jsonType;
        encoder = charset.newEncoder()
            .onMalformedInput(CodingErrorAction.REPLACE)
            .onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    @Override
    public void writeTo(final OutputStream out) throws IOException {
        // try-with-resources not used here intentionally in order to avoid
        // exceptions caused by JsonWriter.close() validations
        JsonWriter writer = jsonType.create(new StreamEncoder(out, encoder));
        jsonContentWriter.writeValue(writer);
        writer.close();
    }
}

