package ru.yandex.http.server.sync;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.EntityTemplate;

import ru.yandex.http.util.CharsetUtils;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonValue;

public class JsonEntity extends EntityTemplate {
    public JsonEntity(final JsonValue writer, final HttpRequest request)
        throws HttpException
    {
        this(writer, request, JsonTypeExtractor.NORMAL);
    }

    public JsonEntity(
        final JsonValue writer,
        final HttpRequest request,
        final JsonTypeExtractor jsonTypeExtractor)
        throws HttpException
    {
        super(
            new JsonContentProducerWriter(
                writer,
                request,
                jsonTypeExtractor));
        setChunked(true);
        setContentType(
            ContentType.APPLICATION_JSON.withCharset(
                CharsetUtils.acceptedCharset(request)).toString());
    }
}

