package ru.yandex.http.server.sync;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.HttpServer;

public class LogRotateHandler implements HttpRequestHandler {
    private final HttpEntity entity =
        new StringEntity("logs rotated", ContentType.TEXT_PLAIN);
    private final HttpServer<?, HttpRequestHandler> server;

    public LogRotateHandler(final HttpServer<?, HttpRequestHandler> server) {
        this.server = server;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException
    {
        server.rotateLogs(context);
        response.setEntity(entity);
        response.setStatusCode(HttpStatus.SC_OK);
    }

    @Override
    public String toString() {
        return "Performs logs rotation";
    }
}

