package ru.yandex.http.server.sync;

import java.io.IOException;
import java.nio.channels.SocketChannel;

import org.apache.http.config.ConnectionConfig;

import ru.yandex.function.GenericAutoCloseable;

public class LoggingHttpServerConnectionFactory
    extends HttpServerConnectionFactory
{
    public LoggingHttpServerConnectionFactory(
        final BaseHttpServer<?> server,
        final ConnectionConfig connectionConfig)
    {
        super(server, connectionConfig);
    }

    @Override
    public LoggingHttpServerConnection create(
        final SocketChannel channel,
        final GenericAutoCloseable<RuntimeException> releaser)
        throws IOException
    {
        return new LoggingHttpServerConnection(
            server,
            channel,
            connectionConfig,
            releaser);
    }
}

