package ru.yandex.http.server.sync;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.HttpServer;

public class OverridableHttpRequestHandler implements HttpRequestHandler {
    private final HttpRequestHandler handler;

    public OverridableHttpRequestHandler(final HttpRequestHandler handler) {
        this.handler = handler;
    }

    public HttpRequestHandler handler() {
        return handler;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException, IOException
    {
        Object overriddenHandler =
            context.getAttribute(HttpServer.OVERRIDDEN_HANDLER);
        HttpRequestHandler handler;
        if (overriddenHandler == null) {
            handler = this.handler;
        } else {
            handler = (HttpRequestHandler) overriddenHandler;
        }
        handler.handle(request, response, context);
    }

    @Override
    public String toString() {
        return handler.toString();
    }
}

