package ru.yandex.http.server.sync;

import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.HttpServer;
import ru.yandex.logger.PrefixedLogger;

public class PingHandler implements HttpRequestHandler {
    private final HttpEntity entity =
        new StringEntity("pong", ContentType.TEXT_PLAIN);

    private final HttpServer<?, ?> server;

    public PingHandler(final HttpServer<?, ?> server) {
        this.server = server;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
    {
        PrefixedLogger logger =
            (PrefixedLogger) context.getAttribute(HttpServer.LOGGER);
        if (server.pingEnabled(logger)) {
            response.setEntity(entity);
        } else {
            response.setStatusCode(HttpStatus.SC_SERVICE_UNAVAILABLE);
        }
    }

    @Override
    public String toString() {
        return "Simple ping-pong handler";
    }
}

