package ru.yandex.http.server.sync;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.HttpServer;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.uri.ScanningCgiParams;

public class RemoveDebugFlagHandler implements HttpRequestHandler {
    private final HttpServer<?, HttpRequestHandler> server;

    public RemoveDebugFlagHandler(
        final HttpServer<?, HttpRequestHandler> server)
    {
        this.server = server;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException
    {
        server.removeDebugFlag(
            new ScanningCgiParams(request)
                .get("flag", NonEmptyValidator.INSTANCE));
        response.setEntity(
            new StringEntity(
                "Debug flags become: " + server.debugFlags(),
                ContentType.TEXT_PLAIN));
        response.setStatusCode(HttpStatus.SC_OK);
    }

    @Override
    public String toString() {
        return "Turns off debug flag";
    }
}

