package ru.yandex.http.server.sync;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.GzipCompressingEntity;
import ru.yandex.http.util.ResponseContentEncodingBase;

public class ResponseContentEncoding extends ResponseContentEncodingBase {
    public ResponseContentEncoding(final boolean gzip, final int bufferSize) {
        super(gzip, bufferSize);
    }

    @Override
    public void process(final HttpResponse response, final HttpContext context)
        throws HttpException, IOException
    {
        if (gzip(response, context)) {
            response.setEntity(
                new GzipCompressingEntity(response.getEntity(), bufferSize));
        }
    }
}

