package ru.yandex.http.server.sync;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SocketChannel;

import org.apache.http.config.ConnectionConfig;

import ru.yandex.function.GenericAutoCloseable;
import ru.yandex.http.server.sync.util.SSLSocketChannelIO;

public class SSLLoggingHttpServerConnection
    extends LoggingHttpServerConnection
{
    private final SSLSocketChannelIO io;

    public SSLLoggingHttpServerConnection(
        final BaseHttpServer<?> server,
        final SocketChannel channel,
        final ConnectionConfig config,
        final GenericAutoCloseable<RuntimeException> releaser)
        throws IOException
    {
        super(server, channel, config, releaser);
        io = new SSLSocketChannelIO(socket, server.createSSLEngine());
    }

    @Override
    protected InputStream getSocketInputStream(final Socket socket)
        throws IOException
    {
        return io.inputStream();
    }

    @Override
    protected OutputStream getSocketOutputStream(final Socket socket)
        throws IOException
    {
        return io.outputStream();
    }

    @Override
    public void close() throws IOException {
        io.close();
        super.close();
    }

    @Override
    public boolean hasBufferedData() {
        return io.hasBufferedData() || super.hasBufferedData();
    }

    @Override
    public boolean needReregister() throws IOException {
        return io.checkHandshake() && !hasBufferedData() && isOpen();
    }
}

