package ru.yandex.http.server.sync;

import java.io.IOException;
import java.nio.channels.SocketChannel;

import org.apache.http.config.ConnectionConfig;

import ru.yandex.function.GenericAutoCloseable;

public class SSLLoggingHttpServerConnectionFactory
    extends HttpServerConnectionFactory
{
    public SSLLoggingHttpServerConnectionFactory(
        final BaseHttpServer<?> server,
        final ConnectionConfig connectionConfig)
    {
        super(server, connectionConfig);
    }

    @Override
    public LoggingHttpServerConnection create(
        final SocketChannel channel,
        final GenericAutoCloseable<RuntimeException> releaser)
        throws IOException
    {
        return new SSLLoggingHttpServerConnection(
            server,
            channel,
            connectionConfig,
            releaser);
    }
}

