package ru.yandex.http.server.sync;

import java.io.IOException;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.JsonStatsConsumer;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonValue;
import ru.yandex.json.writer.JsonWriterBase;
import ru.yandex.stater.Stater;

public class StatHandler implements HttpRequestHandler, JsonValue {
    private final Stater stater;

    public StatHandler(final Stater stater) {
        this.stater = stater;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException
    {
        response.setEntity(
            new JsonEntity(this, request, JsonTypeExtractor.NORMAL));
    }

    @Override
    public String toString() {
        return "Prints server status in golovan format.";
    }

    @Override
    public void writeValue(final JsonWriterBase writer) throws IOException {
        // try-with-resources not used here intentionally in order to avoid
        // exceptions caused by JsonWriter.close() validations and stream close
        JsonStatsConsumer statsConsumer = new JsonStatsConsumer(writer);
        stater.stats(statsConsumer);
        statsConsumer.close();
    }
}

