package ru.yandex.http.server.sync;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.server.HttpServer;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.parser.uri.ScanningCgiParams;

public class StatusHandler implements HttpRequestHandler {
    private final HttpServer<?, HttpRequestHandler> server;

    public StatusHandler(final HttpServer<?, HttpRequestHandler> server) {
        this.server = server;
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException
    {
        boolean verbose =
            new ScanningCgiParams(request).getBoolean("verbose", true);
        response.setEntity(
            new JsonEntity(
                writer -> writer.value(server.status(verbose)),
                request,
                JsonTypeExtractor.HUMAN_READABLE));
        response.setStatusCode(HttpStatus.SC_OK);
    }

    @Override
    public String toString() {
        return
            "Prints server status: amount of active workers, connections etc.";
    }
}

