package ru.yandex.http.server.sync;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.parser.uri.ScanningCgiParams;

public class SystemExitHandler implements HttpRequestHandler {
    private static final int DEFAULT_EXIT_DELAY = 10000;
    private static final int SEC_MILLIS = 1000;

    @Override
    public void handle(
        final HttpRequest request,
        final HttpResponse response,
        final HttpContext context)
        throws HttpException
    {
        ScanningCgiParams cgiParams = new ScanningCgiParams(request);
        if (!cgiParams.getString("password").equals("yes_i_want_this_ugu")) {
            throw new BadRequestException("Authentification failed");
        }
        final int code = cgiParams.getInt("code", 1);
        final int delay = cgiParams.getInt("delay", DEFAULT_EXIT_DELAY);
        final int secs = delay / SEC_MILLIS;
        response.setEntity(
            new StringEntity(
                "exiting in " + secs + " secs...", ContentType.TEXT_PLAIN));
        response.setStatusCode(HttpStatus.SC_OK);
        try {
            Thread.sleep(delay);
            System.exit(code);
        } catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String toString() {
        return "Shutdown server";
    }
}

