package ru.yandex.http.server.sync.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;

@SuppressWarnings("UnsynchronizedOverridesSynchronized")
public class FilterSocket extends Socket {
    protected final Socket sock;

    public FilterSocket(final Socket sock) {
        this.sock = sock;
    }

    @Override
    public void connect(final SocketAddress remote) throws IOException {
        sock.connect(remote);
    }

    @Override
    public void connect(
        final SocketAddress remote,
        final int timeout) throws IOException
    {
        sock.connect(remote, timeout);
    }

    @Override
    public void bind(final SocketAddress local) throws IOException {
        sock.bind(local);
    }

    @Override
    public InetAddress getInetAddress() {
        return sock.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return sock.getLocalAddress();
    }

    @Override
    public int getPort() {
        return sock.getPort();
    }

    @Override
    public int getLocalPort() {
        return sock.getLocalPort();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return sock.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return sock.getOutputStream();
    }

    @Override
    public void setTcpNoDelay(final boolean on) throws SocketException {
        sock.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return sock.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(
        final boolean on,
        final int linger)
        throws SocketException
    {
        sock.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return sock.getSoLinger();
    }

    @Override
    public void sendUrgentData(final int data) throws IOException {
        sock.sendUrgentData(data);
    }

    @Override
    public void setOOBInline(final boolean on) throws SocketException {
        sock.setOOBInline(on);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return sock.getOOBInline();
    }

    @Override
    public void setSoTimeout(final int timeout) throws SocketException {
        sock.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return sock.getSoTimeout();
    }

    @Override
    public void setSendBufferSize(final int size) throws SocketException {
        sock.setSendBufferSize(size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return sock.getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(final int size) throws SocketException {
        sock.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return sock.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(final boolean on) throws SocketException {
        sock.setKeepAlive(on);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return sock.getKeepAlive();
    }

    @Override
    public void setTrafficClass(final int tc) throws SocketException {
        sock.setTrafficClass(tc);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return sock.getTrafficClass();
    }

    @Override
    public void setReuseAddress(final boolean on) throws SocketException {
        sock.setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return sock.getReuseAddress();
    }

    @Override
    public void close() throws IOException {
        sock.close();
    }

    @Override
    public void shutdownInput() throws IOException {
        sock.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        sock.shutdownOutput();
    }

    @Override
    public String toString() {
        return "Filter(" + sock.toString() + ')';
    }

    @Override
    public boolean isConnected() {
        return sock.isConnected();
    }

    @Override
    public boolean isBound() {
        return sock.isBound();
    }

    @Override
    public boolean isClosed() {
        return sock.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return sock.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return sock.isOutputShutdown();
    }
}
