package ru.yandex.http.server.sync.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import org.apache.http.entity.ContentProducer;

public class LazyInputStream extends InputStream {
    private final ContentProducer producer;
    private InputStream in = null;
    private boolean open = true;

    public LazyInputStream(final ContentProducer producer) {
        this.producer = producer;
    }

    public boolean open() {
        return open;
    }

    @Override
    public int available() throws IOException {
        if (in == null) {
            return 0;
        } else {
            return in.available();
        }
    }

    @Override
    public void close() throws IOException {
        if (open()) {
            open = false;
            if (in != null) {
                in.close();
                in = null;
            }
        }
    }

    private void prepareInput() throws IOException {
        if (in == null) {
            if (open()) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                producer.writeTo(out);
                in = new ByteArrayInputStream(out.toByteArray());
            } else {
                throw new IOException("Stream closed");
            }
        }
    }

    @Override
    public int read() throws IOException {
        prepareInput();
        return in.read();
    }

    @Override
    public int read(final byte[] b) throws IOException {
        return read(b, 0, b.length);
    }

    @Override
    public int read(final byte[] b, final int off, final int len)
        throws IOException
    {
        prepareInput();
        return in.read(b, off, len);
    }

    @Override
    public long skip(final long n) throws IOException {
        prepareInput();
        return in.skip(n);
    }
}

