package ru.yandex.http.server.sync.util;

import java.io.IOException;
import java.net.SocketException;

import ru.yandex.http.server.sync.BaseHttpServer;
import ru.yandex.http.server.sync.LoggingHttpServerConnection;

public class ThreadSafeSocketAdaptor extends FilterSocket {
    private final BaseHttpServer<?> server;
    private final LoggingHttpServerConnection conn;
    private final SocketChannelOutputStream outputStream;

    public ThreadSafeSocketAdaptor(
        final BaseHttpServer<?> server,
        final LoggingHttpServerConnection conn)
        throws IOException
    {
        super(conn.channel().socket());
        this.server = server;
        this.conn = conn;
        outputStream = new SocketChannelOutputStream(
            this,
            conn.channel(),
            sock.getSoTimeout());
    }

    @Override
    @SuppressWarnings("UnsynchronizedOverridesSynchronized")
    public void setSoTimeout(final int timeout) throws SocketException {
        super.setSoTimeout(timeout);
        outputStream.setSoTimeout(timeout);
    }

    @Override
    public SocketChannelOutputStream getOutputStream() {
        return outputStream;
    }

    @Override
    @SuppressWarnings("UnsynchronizedOverridesSynchronized")
    public void close() throws IOException {
        server.defferClose(conn);
    }
}
