package ru.yandex.http.util.server;

import java.util.HashSet;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractAuthConfigBuilder
    <T extends AbstractAuthConfigBuilder<T>>
    implements AuthConfig
{
    private String headerName;
    private Set<Integer> allowedSrcs;
    private boolean strict;
    private boolean bypassLoopback;
    private String userTicketHeaderName;
    private UserTicketPresence userTicketPresence;

    protected AbstractAuthConfigBuilder(final AuthConfig config) {
        headerName(config.headerName());
        allowedSrcs(config.allowedSrcs());
        strict(config.strict());
        bypassLoopback(config.bypassLoopback());
        userTicketHeaderName(config.userTicketHeaderName());
        userTicketPresence(config.userTicketPresence());
    }

    protected AbstractAuthConfigBuilder(
        final IniConfig config,
        final AuthConfig defaults)
        throws ConfigException
    {
        headerName = HEADER_NAME.extract(config, defaults.headerName());
        allowedSrcs = ALLOWED_SRCS.extract(config, defaults.allowedSrcs());
        strict = STRICT.extract(config, defaults.strict());
        bypassLoopback =
            BYPASS_LOOPBACK.extract(config, defaults.bypassLoopback());
        userTicketHeaderName =
            USER_TICKET_HEADER_NAME.extract(
                config,
                defaults.userTicketHeaderName());
        userTicketPresence =
            USER_TICKET_PRESENCE.extract(
                config,
                defaults.userTicketPresence());
    }

    protected abstract T self();

    @Override
    public String headerName() {
        return headerName;
    }

    public T headerName(final String headerName) {
        this.headerName = headerName;
        return self();
    }

    @Override
    public Set<Integer> allowedSrcs() {
        return allowedSrcs;
    }

    public T allowedSrcs(final Set<Integer> allowedSrcs) {
        this.allowedSrcs = new HashSet<>(allowedSrcs);
        return self();
    }

    @Override
    public boolean strict() {
        return strict;
    }

    public T strict(final boolean strict) {
        this.strict = strict;
        return self();
    }

    @Override
    public boolean bypassLoopback() {
        return bypassLoopback;
    }

    public T bypassLoopback(final boolean bypassLoopback) {
        this.bypassLoopback = bypassLoopback;
        return self();
    }

    @Override
    public String userTicketHeaderName() {
        return userTicketHeaderName;
    }

    public T userTicketHeaderName(final String userTicketHeaderName) {
        this.userTicketHeaderName = userTicketHeaderName;
        return self();
    }

    @Override
    public UserTicketPresence userTicketPresence() {
        return userTicketPresence;
    }

    public T userTicketPresence(final UserTicketPresence userTicketPresence) {
        this.userTicketPresence = userTicketPresence;
        return self();
    }
}

