package ru.yandex.http.util.server;

import java.util.Map;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.collection.PatternStringPredicate;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.request.RequestPatternParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractAuthsConfigBuilder
    <T extends AbstractAuthsConfigBuilder<T>>
    implements AuthsConfig
{
    private PatternMap<RequestInfo, AuthConfigBuilder> auths;

    protected AbstractAuthsConfigBuilder(final AuthsConfig config) {
        auths(config.auths());
    }

    protected AbstractAuthsConfigBuilder(
        final IniConfig config,
        final AuthsConfig defaults)
        throws ConfigException
    {
        auths = loadAuths(config.section("auth"), defaults.auths());
    }

    protected abstract T self();

    public static PatternMap<RequestInfo, AuthConfigBuilder> loadAuths(
        final IniConfig section,
        final PatternMap<RequestInfo, ? extends AuthConfig> defaults)
        throws ConfigException
    {
        PatternMap<RequestInfo, AuthConfigBuilder> auths = new PatternMap<>(
            new AuthConfigBuilder(section, defaults.asterisk()));
        for (Map.Entry<String, IniConfig> entry
            : section.sections().entrySet())
        {
            String subsection = entry.getKey();
            if (PatternStringPredicate.INSTANCE.test(subsection)) {
                Pattern<RequestInfo> pattern =
                    RequestPatternParser.INSTANCE.apply(subsection);
                auths.put(
                    pattern,
                    new AuthConfigBuilder(
                        entry.getValue(),
                        defaults.get(pattern)));
            }
        }
        return auths;
    }

    @Override
    public PatternMap<RequestInfo, AuthConfigBuilder> auths() {
        return auths;
    }

    public T auths(final PatternMap<RequestInfo, ? extends AuthConfig> auths) {
        this.auths = auths.transform(config -> new AuthConfigBuilder(config));
        return self();
    }
}

