package ru.yandex.http.util.server;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.stater.StaterConfig;
import ru.yandex.stater.StaterConfigBuilder;

public abstract class AbstractAutoRegisterRequestStaterConfigBuilder
    <T extends AbstractAutoRegisterRequestStaterConfigBuilder<T>>
     implements AutoRegisterRequestStaterConfig
{
    private AutoRegisterStatus status;
    private StaterConfigBuilder staterConfig;

    protected AbstractAutoRegisterRequestStaterConfigBuilder(
        final AutoRegisterRequestStaterConfig config)
    {
        status(config.status());
        staterConfig(config.staterConfig());
    }

    protected AbstractAutoRegisterRequestStaterConfigBuilder(
        final IniConfig config,
        final AutoRegisterRequestStaterConfig defaults)
        throws ConfigException
    {
        this.status = config.getEnum(AutoRegisterStatus.class, "status", defaults.status());
        this.staterConfig =
            new StaterConfigBuilder(
                config.section("stater"),
                defaults.staterConfig());
    }

    @Override()
    public AutoRegisterStatus status() {
        return status;
    }

    public T status(final AutoRegisterStatus value) {
        this.status = value;
        return self();
    }

    @Override()
    public StaterConfigBuilder staterConfig() {
        return staterConfig;
    }

    public T staterConfig(final StaterConfig value) {
        this.staterConfig = new StaterConfigBuilder(value);
        return self();
    }

    protected abstract T self();
}
