package ru.yandex.http.util.server;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.StringEntity;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.CharsetUtils;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.uri.CgiParams;

public class AbstractConfigUpdateHandler {
    private final AbstractHttpServer<?, ?> server;

    public AbstractConfigUpdateHandler(final AbstractHttpServer<?, ?> server) {
        this.server = server;
    }

    protected HttpEntity entityOrNull(final HttpRequest request)
        throws BadRequestException
    {
        HttpEntity entity = null;
        if (request instanceof HttpEntityEnclosingRequest) {
            entity = ((HttpEntityEnclosingRequest) request).getEntity();
            if (entity.getContentLength() == 0) {
                entity = null;
            }
        }

        return entity;
    }

    protected HttpEntity handle(
        final HttpRequest request,
        final PrefixedLogger logger)
        throws HttpException, IOException
    {
        try {
            IniConfig config;
            HttpEntity entity = entityOrNull(request);
            CgiParams params = new CgiParams(request);
            File fileConfig = params.getInputFile("file", null);
            if (fileConfig != null) {
                logger.info("Loading config file " + fileConfig);
                config = new IniConfig(fileConfig);
            } else if (entity != null) {
                logger.info("Updating by post request");
                config = new IniConfig(CharsetUtils.content(entity));
            } else {
                throw new BadRequestException("Should be post content or file param specified");
            }

            server.updateDynamicConfig(config, logger);
            logger.info("dynamic config updated: " + config.toStringFast());
        } catch (ConfigException ce) {
            throw new BadRequestException("Invalid config supplied", ce);
        }

        return new StringEntity("Updated", StandardCharsets.UTF_8);
    }

    @Override
    public String toString() {
        return "Updates server dynamic config";
    }
}
