package ru.yandex.http.util.server;

import java.nio.file.Path;
import java.util.regex.Pattern;

import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractFilesStaterConfigBuilder
    <T extends AbstractFilesStaterConfigBuilder<T>>
    implements ConfigBuilder<T>, FilesStaterConfig
{
    private Path root;
    private Pattern regexFilter;
    private int maxFiles;

    protected AbstractFilesStaterConfigBuilder(
        final FilesStaterConfig config)
    {
        root(config.root());
        regexFilter(config.regexFilter());
        maxFiles(config.maxFiles());
    }

    protected AbstractFilesStaterConfigBuilder(
        final IniConfig config,
        final FilesStaterConfig defaults)
        throws ConfigException
    {
        root = ROOT.extract(config, defaults.root());
        regexFilter = REGEX_FILTER.extract(config, defaults.regexFilter());
        maxFiles = MAX_FILES.extract(config, defaults.maxFiles());
    }

    @Override
    public Path root() {
        return root;
    }

    public T root(final Path root) {
        this.root = root;
        return self();
    }

    @Override
    public Pattern regexFilter() {
        return regexFilter;
    }

    public T regexFilter(final Pattern regexFilter) {
        this.regexFilter = regexFilter;
        return self();
    }

    @Override
    public int maxFiles() {
        return maxFiles;
    }

    public T maxFiles(final int maxFiles) {
        this.maxFiles = maxFiles;
        return self();
    }
}

