package ru.yandex.http.util.server;

import ru.yandex.http.util.request.function.RequestFunction;
import ru.yandex.parser.config.ConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractLimiterConfigBuilder
    <T extends AbstractLimiterConfigBuilder<T>>
    implements ConfigBuilder<T>, LimiterConfig
{
    private int concurrency;
    private int perKeyConcurrency;
    private int perKeyMinimalConcurrency;
    private RequestFunction<LimiterFunctionContext> key;
    private long memoryLimit;
    private int errorStatusCode;
    private boolean bypassLoopback;
    private String staterPrefix;

    protected AbstractLimiterConfigBuilder(final LimiterConfig config) {
        concurrency(config.concurrency());
        perKeyConcurrency(config.perKeyConcurrency());
        perKeyMinimalConcurrency(config.perKeyMinimalConcurrency());
        key(config.key());
        memoryLimit(config.memoryLimit());
        errorStatusCode(config.errorStatusCode());
        staterPrefix(config.staterPrefix());
        bypassLoopback(config.bypassLoopback());
    }

    protected AbstractLimiterConfigBuilder(
        final IniConfig config,
        final LimiterConfig defaults)
        throws ConfigException
    {
        concurrency = CONCURRENCY.extract(config, defaults.concurrency());
        perKeyConcurrency =
            PER_KEY_CONCURRENCY.extract(config, defaults.perKeyConcurrency());
        perKeyMinimalConcurrency = PER_KEY_MINIMAL_CONCURRENCY.extract(
            config,
            defaults.perKeyMinimalConcurrency());
        key = KEY.extract(config, defaults.key());
        memoryLimit = MEMORY_LIMIT.extract(config, defaults.memoryLimit());
        errorStatusCode =
            ERROR_STATUS_CODE.extract(config, defaults.errorStatusCode());
        staterPrefix = STATER_PREFIX.extract(config, defaults.staterPrefix());
        bypassLoopback = BYPASS_LOOPBACK.extract(config, defaults.bypassLoopback());
    }

    @Override
    public int concurrency() {
        return concurrency;
    }

    public T concurrency(final int concurrency) {
        this.concurrency = concurrency;
        return self();
    }

    @Override
    public int perKeyConcurrency() {
        return perKeyConcurrency;
    }

    public T perKeyConcurrency(final int perKeyConcurrency) {
        this.perKeyConcurrency = perKeyConcurrency;
        return self();
    }

    @Override
    public int perKeyMinimalConcurrency() {
        return perKeyMinimalConcurrency;
    }

    public T perKeyMinimalConcurrency(final int perKeyMinimalConcurrency) {
        this.perKeyMinimalConcurrency = perKeyMinimalConcurrency;
        return self();
    }

    @Override
    public RequestFunction<LimiterFunctionContext> key() {
        return key;
    }

    public T key(final RequestFunction<LimiterFunctionContext> key) {
        this.key = key;
        return self();
    }

    @Override
    public long memoryLimit() {
        return memoryLimit;
    }

    public T memoryLimit(final long memoryLimit) {
        this.memoryLimit = memoryLimit;
        return self();
    }

    @Override
    public int errorStatusCode() {
        return errorStatusCode;
    }

    public T errorStatusCode(final int errorStatusCode) {
        this.errorStatusCode = errorStatusCode;
        return self();
    }

    @Override
    public String staterPrefix() {
        return staterPrefix;
    }

    public T staterPrefix(final String staterPrefix) {
        this.staterPrefix = staterPrefix;
        return self();
    }

    @Override
    public boolean bypassLoopback() {
        return bypassLoopback;
    }

    public T bypassLoopback(final boolean bypassLoopback) {
        this.bypassLoopback = bypassLoopback;
        return self();
    }
}
