package ru.yandex.http.util.server;

import java.util.Map;

import ru.yandex.collection.Pattern;
import ru.yandex.collection.PatternMap;
import ru.yandex.collection.PatternStringPredicate;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.request.RequestPatternParser;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractLimitersConfigBuilder
    <T extends AbstractLimitersConfigBuilder<T>>
    implements LimitersConfig
{
    private PatternMap<RequestInfo, LimiterConfigBuilder> limiters;

    protected AbstractLimitersConfigBuilder(final LimitersConfig config) {
        limiters(config.limiters());
    }

    protected AbstractLimitersConfigBuilder(
        final IniConfig config,
        final LimitersConfig defaults)
        throws ConfigException
    {
        limiters = loadLimiters(config.section("limiter"), defaults.limiters());
    }

    protected abstract T self();

    public static PatternMap<RequestInfo, LimiterConfigBuilder> loadLimiters(
        final IniConfig section,
        final PatternMap<RequestInfo, ? extends LimiterConfig> defaults)
        throws ConfigException
    {
        PatternMap<RequestInfo, LimiterConfigBuilder> limiters =
            new PatternMap<>(
                new LimiterConfigBuilder(section, defaults.asterisk()));
        for (Map.Entry<String, IniConfig> entry
            : section.sections().entrySet())
        {
            String subsection = entry.getKey();
            if (PatternStringPredicate.INSTANCE.test(subsection)) {
                Pattern<RequestInfo> pattern =
                    RequestPatternParser.INSTANCE.apply(subsection);
                limiters.put(
                    pattern,
                    new LimiterConfigBuilder(
                        entry.getValue(),
                        defaults.get(pattern)));
            }
        }
        return limiters;
    }

    @Override
    public PatternMap<RequestInfo, LimiterConfigBuilder> limiters() {
        return limiters;
    }

    public T limiters(
        final PatternMap<RequestInfo, ? extends LimiterConfig> limiters)
    {
        this.limiters =
            limiters.transform(config -> new LimiterConfigBuilder(config));
        return self();
    }
}

