package ru.yandex.http.util.server;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.string.CollectionParser;

public enum AllowedSrcsParser
    implements GenericFunction<String, Set<Integer>, RuntimeException>
{
    INSTANCE;

    private static final GenericFunction<
        String,
        Set<Integer>,
        RuntimeException>
            PARSER = new CollectionParser<>(
                x -> Integer.parseInt(x.trim()),
                HashSet::new);

    @Override
    public Set<Integer> apply(final String value) {
        String trimmed = value.trim();
        if (trimmed.isEmpty()) {
            return Collections.emptySet();
        } else {
            return PARSER.apply(trimmed);
        }
    }
}

