package ru.yandex.http.util.server;

import java.util.Set;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.EnumParser;
import ru.yandex.parser.string.NonEmptyValidator;

public interface AuthConfig {
    ParameterConfig<String> HEADER_NAME = new ParameterConfig<>(
        "header-name",
        x -> x,
        NonEmptyValidator.INSTANCE);
    ParameterConfig<Set<Integer>> ALLOWED_SRCS = new ParameterConfig<>(
        "allowed-srcs",
        AllowedSrcsParser.INSTANCE,
        x -> x);
    ParameterConfig<Boolean> STRICT =
        new ParameterConfig<>("strict", BooleanParser.INSTANCE, x -> x);
    ParameterConfig<Boolean> BYPASS_LOOPBACK = new ParameterConfig<>(
        "bypass-loopback",
        BooleanParser.INSTANCE,
        x -> x);
    ParameterConfig<String> USER_TICKET_HEADER_NAME = new ParameterConfig<>(
        "user-ticket-header-name",
        x -> x,
        NonEmptyValidator.INSTANCE);
    ParameterConfig<UserTicketPresence> USER_TICKET_PRESENCE =
        new ParameterConfig<>(
            "user-ticket-presence",
            new EnumParser<>(UserTicketPresence.class),
            GenericFunction.identity());

    String headerName();

    Set<Integer> allowedSrcs();

    boolean strict();

    boolean bypassLoopback();

    String userTicketHeaderName();

    UserTicketPresence userTicketPresence();
}

