package ru.yandex.http.util.server;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class AuthConfigBuilder
    extends AbstractAuthConfigBuilder<AuthConfigBuilder>
{
    public AuthConfigBuilder() {
        super(AuthConfigDefaults.INSTANCE);
    }

    public AuthConfigBuilder(final AuthConfig config) {
        super(config);
    }

    public AuthConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, AuthConfigDefaults.INSTANCE);
    }

    public AuthConfigBuilder(
        final IniConfig config,
        final AuthConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public AuthConfigBuilder self() {
        return this;
    }

    public ImmutableAuthConfig build() throws ConfigException {
        return new ImmutableAuthConfig(this);
    }
}

