package ru.yandex.http.util.server;

import java.util.Collections;
import java.util.Set;

import ru.yandex.http.util.YandexHeaders;

public class AuthConfigDefaults implements AuthConfig {
    public static final AuthConfigDefaults INSTANCE = new AuthConfigDefaults();

    protected AuthConfigDefaults() {
    }

    @Override
    public String headerName() {
        return YandexHeaders.X_YA_SERVICE_TICKET;
    }

    @Override
    public Set<Integer> allowedSrcs() {
        return Collections.emptySet();
    }

    @Override
    public boolean strict() {
        return false;
    }

    @Override
    public boolean bypassLoopback() {
        return false;
    }

    @Override
    public String userTicketHeaderName() {
        return YandexHeaders.X_YA_USER_TICKET;
    }

    @Override
    public UserTicketPresence userTicketPresence() {
        return UserTicketPresence.IGNORED;
    }
}

