package ru.yandex.http.util.server;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class AuthsConfigBuilder
    extends AbstractAuthsConfigBuilder<AuthsConfigBuilder>
{
    public AuthsConfigBuilder() {
        super(AuthsConfigDefaults.INSTANCE);
    }

    public AuthsConfigBuilder(final AuthsConfig config) {
        super(config);
    }

    public AuthsConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, AuthsConfigDefaults.INSTANCE);
    }

    public AuthsConfigBuilder(
        final IniConfig config,
        final AuthsConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public AuthsConfigBuilder self() {
        return this;
    }

    public ImmutableAuthsConfig build() throws ConfigException {
        return new ImmutableAuthsConfig(this);
    }
}

