package ru.yandex.http.util.server;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.stater.HttpCodesMetric;
import ru.yandex.stater.MetricBuilder;
import ru.yandex.stater.RequestTimeHistogramMetric;
import ru.yandex.stater.StaterConfig;
import ru.yandex.stater.StaterConfigBuilder;

public class AutoRegisterRequestStaterConfigDefaults
     implements AutoRegisterRequestStaterConfig
{
    public static final AutoRegisterRequestStaterConfigDefaults INSTANCE =
        new AutoRegisterRequestStaterConfigDefaults();
    private static final StaterConfig DEFAULT_STATER_CONFIG;

    static {
        final List<MetricBuilder> metrics = new ArrayList<>();

        try {
            final IniConfig fakeConfig =
                new IniConfig(
                    new StringReader(
                        "precise-histogram=false\n" +
                            "processing-time-stats=false\n" +
                            "httpcode-ranges=total, 200-299 (2xx), 400-498 (4xx), 499 (timeout), 500-599 (5xx)\n"));
            metrics.add(
                new HttpCodesMetric(fakeConfig));
            metrics.add(
                new RequestTimeHistogramMetric(fakeConfig));
        } catch (IOException | ConfigException e) {
            throw new RuntimeException(e);
        }

        DEFAULT_STATER_CONFIG = new StaterConfigBuilder().metrics(metrics).build();
    }

    protected AutoRegisterRequestStaterConfigDefaults() {
    }

    @Override
    public AutoRegisterStatus status() {
        return AutoRegisterStatus.DISABLED;
    }

    @Override
    public StaterConfig staterConfig() {
        return DEFAULT_STATER_CONFIG;
    }
}
