package ru.yandex.http.util.server;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class BaseServerConfigBuilder
    extends AbstractBaseServerConfigBuilder<BaseServerConfigBuilder>
{
    public BaseServerConfigBuilder() {
        super(BaseServerConfigDefaults.INSTANCE);
    }

    public BaseServerConfigBuilder(final BaseServerConfig config) {
        super(config);
    }

    public BaseServerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, BaseServerConfigDefaults.INSTANCE);
    }

    public BaseServerConfigBuilder(
        final IniConfig config,
        final String section)
        throws ConfigException
    {
        super(config, section, BaseServerConfigDefaults.INSTANCE);
    }

    @Override
    public BaseServerConfigBuilder self() {
        return this;
    }

    public ImmutableBaseServerConfig build() throws ConfigException {
        return new ImmutableBaseServerConfig(this);
    }
}

