package ru.yandex.http.util.server;

import ru.yandex.client.tvm2.Tvm2ServiceConfig;
import ru.yandex.http.config.DnsConfig;
import ru.yandex.http.config.DnsConfigDefaults;
import ru.yandex.logger.LoggersConfig;
import ru.yandex.logger.LoggersConfigDefaults;
import ru.yandex.stater.GolovanPanelConfig;
import ru.yandex.stater.StatersConfig;
import ru.yandex.stater.StatersConfigDefaults;

public class BaseServerConfigDefaults
    extends HttpServerConfigDefaults
    implements BaseServerConfig
{
    public static final BaseServerConfigDefaults INSTANCE =
        new BaseServerConfigDefaults();

    protected BaseServerConfigDefaults() {
    }

    @Override
    public DnsConfig dnsConfig() {
        return DnsConfigDefaults.INSTANCE;
    }

    @Override
    public Tvm2ServiceConfig tvm2ServiceConfig() {
        return null;
    }

    @Override
    public LoggersConfig loggers() {
        return LoggersConfigDefaults.INSTANCE;
    }

    @Override
    public StatersConfig staters() {
        return StatersConfigDefaults.INSTANCE;
    }

    @Override
    public AuthsConfig auths() {
        return AuthsConfigDefaults.INSTANCE;
    }

    @Override
    public LimitersConfig limiters() {
        return LimitersConfigDefaults.INSTANCE;
    }

    @Override
    public GolovanPanelConfig golovanPanel() {
        return null;
    }

    @Override
    public AutoRegisterRequestStaterConfig autoRegisterRequestStater() {
        return AutoRegisterRequestStaterConfigDefaults.INSTANCE;
    }
}

