package ru.yandex.http.util.server;

import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class BaseServerDynamicConfig {
    protected final ImmutableBaseServerConfig staticConfig;
    protected volatile ImmutableLimitersConfig limitersConfig;

    public BaseServerDynamicConfig(final ImmutableBaseServerConfig staticConfig) {
        this.staticConfig = staticConfig;
        this.limitersConfig = staticConfig.limiters();
    }

    public ImmutableLimitersConfig limiters() {
        return limitersConfig;
    }

    public synchronized void update(
        final IniConfig config,
        final PrefixedLogger logger)
        throws ConfigException
    {
        this.limitersConfig =
            new ImmutableLimitersConfig(
                this.limitersConfig,
                new LimitersConfigBuilder(config));

        StringBuilder sb = new StringBuilder();
        limitersConfig.limiters().traverse((p, v) -> {
            sb.append(p);
            sb.append(": ");
            sb.append(v);
            sb.append("\n");
        });
        logger.info("Limiters updated " + sb.toString());
    }
}
