package ru.yandex.http.util.server;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class DefaultHttpServerFactory<C extends ImmutableBaseServerConfig>
    implements HttpServerFactory<C, Object>
{
    private static final String IMMUTABLE = "Immutable";
    private static final String CONFIG = "Config";

    private final String serverName;

    @SuppressWarnings("StringSplitter")
    public DefaultHttpServerFactory() {
        this(System.getProperty("sun.java.command").split(" ")[0]);
    }

    public DefaultHttpServerFactory(final Class<?> clazz) {
        this(clazz.getName());
    }

    public DefaultHttpServerFactory(final String serverName) {
        this.serverName = serverName;
    }

    @Override
    public String name() {
        return serverName;
    }

    @Override
    public HttpServer<C, Object> create(final IniConfig config)
        throws ConfigException, IOException
    {
        try {
            try {
                return doCreate(config);
            } catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ConfigException) {
                    throw (ConfigException) cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException) cause;
                }
                throw e;
            }
        } catch (ReflectiveOperationException e) {
            throw new ConfigException("Failed to construct config", e);
        }
    }

    private HttpServer<C, Object> doCreate(final IniConfig config)
        throws ConfigException, IOException, ReflectiveOperationException
    {
        Class<?> serverClass = Class.forName(serverName);
        for (Constructor<?> constructor: serverClass.getConstructors()) {
            Class<?>[] parameters = constructor.getParameterTypes();
            if (parameters.length == 1) {
                Class<?> immutableConfigClass = parameters[0];
                String name = immutableConfigClass.getName();
                String shortName = name.substring(name.lastIndexOf('.') + 1);
                if (shortName.startsWith(IMMUTABLE) && name.endsWith(CONFIG)) {
                    String packageName =
                        name.substring(0, name.length() - shortName.length());
                    System.err.println("Package name: " + packageName);
                    String configName =
                        packageName + shortName.substring(IMMUTABLE.length());
                    System.err.println("Config name: " + configName);
                    Class<?> configClass = Class.forName(configName);
                    Class<?> configBuilderClass =
                        Class.forName(configName + "Builder");
                    System.err.println("Config class: " + configBuilderClass);
                    Object configBuilder = configBuilderClass
                        .getConstructor(config.getClass())
                        .newInstance(config);
                    System.err.println("Config builder: " + configBuilder.getClass());
                    System.err.println("Config: " + config);
                    Object immutableConfig = immutableConfigClass
                        .getConstructor(configClass)
                        .newInstance(configBuilder);
                    Object server = serverClass
                        .getConstructor(immutableConfigClass)
                        .newInstance(immutableConfig);
                    return cast(server);
                }
            }
        }
        throw new ConfigException(
            "No suitable constructor found for " + serverName);
    }

    @SuppressWarnings("unchecked")
    private static <C extends ImmutableBaseServerConfig> HttpServer<C, Object>
        cast(final Object server)
    {
        return (HttpServer<C, Object>) server;
    }
}

