package ru.yandex.http.util.server;

import java.io.IOException;

import org.apache.http.HttpException;

import ru.yandex.http.config.ImmutableExternalDataConfig;
import ru.yandex.parser.config.ConfigException;

public interface ExternalDataProvider {
    void addExternalDataUpdater(
        String name,
        ImmutableExternalDataConfig config)
        throws ConfigException, HttpException, IOException;

    void addExternalDataUpdater(
        String name,
        ImmutableExternalDataConfig config,
        ExternalDataSubscriber subscriber)
        throws ConfigException, HttpException, IOException;

    void subscribeForExternalDataUpdates(
        String name,
        ExternalDataSubscriber subscriber)
        throws ConfigException, HttpException, IOException;
}

